class MH2_TriggeredMine extends TournamentPickup;

#exec obj load file=..\Textures\Crypt2.utx package=Crypt2

#exec mesh import mesh=MH2_mine1 anivfile=Models\MH2_mine1_a.3d datafile=Models\MH2_mine1_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=MH2_mine1 x=0 y=0 z=0
#exec mesh sequence mesh=MH2_mine1 seq=All startframe=0 numframes=1

#exec meshmap new meshmap=MH2_mine1 mesh=MH2_mine1
#exec meshmap scale meshmap=MH2_mine1 x=0.01563 y=0.01563 z=0.03125

var() class<actor> SpawnWhenSteppedOn[4];
/*
event float BotDesireability(Pawn Bot)
{
	return (0); 
}
*/
function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
	function Touch( actor Other )
		{
		if ( ValidTouch(Other) ) 
			{
			if( Other.IsA('PlayerPawn') || Other.IsA('Bot') )
				{
				if ( SpawnWhenSteppedOn[0] != none )
					{
					Spawn(SpawnWhenSteppedOn[0],,,Self.Location);
					}
				if ( SpawnWhenSteppedOn[1] != none )
					{
					Spawn(SpawnWhenSteppedOn[1],,,Self.Location);
					}
				if ( SpawnWhenSteppedOn[2] != none )
					{
					Spawn(SpawnWhenSteppedOn[2],,,Self.Location);
					}
				if ( SpawnWhenSteppedOn[3] != none )
					{
					Spawn(SpawnWhenSteppedOn[3],,,Self.Location);
					}
				PlayPickupMessage(Pawn(Other));
				Self.Destroy();
				}	
				}
	}
}

defaultproperties
{
     PickupMessage="You fool! You stepped on a mine!"
     DrawType=DT_Mesh
     Mesh=Mesh'MH2_mine1'
     PickupViewMesh=Mesh'MH2_mine1'
     bHidden=False
     SpawnWhenSteppedOn(0)=class'MH2_Effect_mineExpl'
     SpawnWhenSteppedOn(1)=
     SpawnWhenSteppedOn(2)=
     SpawnWhenSteppedOn(3)=
     CollisionRadius=12.00000
     CollisionHeight=6.00000
     bCollideWhenPlacing=True
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     MultiSkins(0)=Texture'UnrealShare.Belt_fx.ShieldBelt.RedShield'
     MultiSkins(1)=Texture'Crypt2.Base.C_rsteel'
}
